#!/bin/bash

# build container based genomic dependencies

# https://hub.docker.com/r/bschiffthaler/trimmomatic
apptainer pull trimmomatic.sif docker://bschiffthaler/trimmomatic:0.39
apptainer pull bwa.sif docker://bschiffthaler/bwa:0.7.17
apptainer pull samtools.sif docker://bschiffthaler/samtools:1.14
apptainer pull bcftools.sif docker://bschiffthaler/bcftools:1.15

# test them
LOG=apptainer.log
echo BCFTOOLS > $LOG
apptainer run --writable-tmpfs bcftools.sif 2>> $LOG
echo BWA >> $LOG
apptainer run --writable-tmpfs bwa.sif 2>> $LOG
echo SAMTOOLS >> $LOG
apptainer run --writable-tmpfs samtools.sif 2>> $LOG
echo TRIMMOMATIC >> $LOG
apptainer run --writable-tmpfs trimmomatic.sif -version >> $LOG
